<?php

class Procedimento extends TRecord
{
    const TABLENAME  = 'procedimento';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('codigo_procedimento');
        parent::addAttribute('descricao_procedimento');
            
    }

    /**
     * Method getEscalas
     */
    public function getEscalas()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_procedimento', '=', $this->id));
        return Escala::getObjects( $criteria );
    }
    /**
     * Method getAgendamentos
     */
    public function getAgendamentos()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_procedimento', '=', $this->id));
        return Agendamento::getObjects( $criteria );
    }

    public function set_escala_equipe_to_string($escala_equipe_to_string)
    {
        if(is_array($escala_equipe_to_string))
        {
            $values = Equipe::where('id', 'in', $escala_equipe_to_string)->getIndexedArray('id', 'id');
            $this->escala_equipe_to_string = implode(', ', $values);
        }
        else
        {
            $this->escala_equipe_to_string = $escala_equipe_to_string;
        }

        $this->vdata['escala_equipe_to_string'] = $this->escala_equipe_to_string;
    }

    public function get_escala_equipe_to_string()
    {
        if(!empty($this->escala_equipe_to_string))
        {
            return $this->escala_equipe_to_string;
        }
    
        $values = Escala::where('id_procedimento', '=', $this->id)->getIndexedArray('id_equipe','{equipe->id}');
        return implode(', ', $values);
    }

    public function set_escala_profissional_to_string($escala_profissional_to_string)
    {
        if(is_array($escala_profissional_to_string))
        {
            $values = Profissional::where('id', 'in', $escala_profissional_to_string)->getIndexedArray('id', 'id');
            $this->escala_profissional_to_string = implode(', ', $values);
        }
        else
        {
            $this->escala_profissional_to_string = $escala_profissional_to_string;
        }

        $this->vdata['escala_profissional_to_string'] = $this->escala_profissional_to_string;
    }

    public function get_escala_profissional_to_string()
    {
        if(!empty($this->escala_profissional_to_string))
        {
            return $this->escala_profissional_to_string;
        }
    
        $values = Escala::where('id_procedimento', '=', $this->id)->getIndexedArray('id_profissional','{profissional->id}');
        return implode(', ', $values);
    }

    public function set_escala_turno_to_string($escala_turno_to_string)
    {
        if(is_array($escala_turno_to_string))
        {
            $values = Turno::where('id', 'in', $escala_turno_to_string)->getIndexedArray('id', 'id');
            $this->escala_turno_to_string = implode(', ', $values);
        }
        else
        {
            $this->escala_turno_to_string = $escala_turno_to_string;
        }

        $this->vdata['escala_turno_to_string'] = $this->escala_turno_to_string;
    }

    public function get_escala_turno_to_string()
    {
        if(!empty($this->escala_turno_to_string))
        {
            return $this->escala_turno_to_string;
        }
    
        $values = Escala::where('id_procedimento', '=', $this->id)->getIndexedArray('id_turno','{turno->id}');
        return implode(', ', $values);
    }

    public function set_escala_unidade_saude_to_string($escala_unidade_saude_to_string)
    {
        if(is_array($escala_unidade_saude_to_string))
        {
            $values = UnidadeSaude::where('id', 'in', $escala_unidade_saude_to_string)->getIndexedArray('id', 'id');
            $this->escala_unidade_saude_to_string = implode(', ', $values);
        }
        else
        {
            $this->escala_unidade_saude_to_string = $escala_unidade_saude_to_string;
        }

        $this->vdata['escala_unidade_saude_to_string'] = $this->escala_unidade_saude_to_string;
    }

    public function get_escala_unidade_saude_to_string()
    {
        if(!empty($this->escala_unidade_saude_to_string))
        {
            return $this->escala_unidade_saude_to_string;
        }
    
        $values = Escala::where('id_procedimento', '=', $this->id)->getIndexedArray('id_unidade_saude','{unidade_saude->id}');
        return implode(', ', $values);
    }

    public function set_escala_procedimento_to_string($escala_procedimento_to_string)
    {
        if(is_array($escala_procedimento_to_string))
        {
            $values = Procedimento::where('id', 'in', $escala_procedimento_to_string)->getIndexedArray('id', 'id');
            $this->escala_procedimento_to_string = implode(', ', $values);
        }
        else
        {
            $this->escala_procedimento_to_string = $escala_procedimento_to_string;
        }

        $this->vdata['escala_procedimento_to_string'] = $this->escala_procedimento_to_string;
    }

    public function get_escala_procedimento_to_string()
    {
        if(!empty($this->escala_procedimento_to_string))
        {
            return $this->escala_procedimento_to_string;
        }
    
        $values = Escala::where('id_procedimento', '=', $this->id)->getIndexedArray('id_procedimento','{procedimento->id}');
        return implode(', ', $values);
    }

    public function set_escala_ocupacao_to_string($escala_ocupacao_to_string)
    {
        if(is_array($escala_ocupacao_to_string))
        {
            $values = Ocupacao::where('id', 'in', $escala_ocupacao_to_string)->getIndexedArray('descricao_ocupacao', 'descricao_ocupacao');
            $this->escala_ocupacao_to_string = implode(', ', $values);
        }
        else
        {
            $this->escala_ocupacao_to_string = $escala_ocupacao_to_string;
        }

        $this->vdata['escala_ocupacao_to_string'] = $this->escala_ocupacao_to_string;
    }

    public function get_escala_ocupacao_to_string()
    {
        if(!empty($this->escala_ocupacao_to_string))
        {
            return $this->escala_ocupacao_to_string;
        }
    
        $values = Escala::where('id_procedimento', '=', $this->id)->getIndexedArray('id_ocupacao','{ocupacao->descricao_ocupacao}');
        return implode(', ', $values);
    }

    public function set_agendamento_paciente_to_string($agendamento_paciente_to_string)
    {
        if(is_array($agendamento_paciente_to_string))
        {
            $values = Paciente::where('id', 'in', $agendamento_paciente_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_paciente_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_paciente_to_string = $agendamento_paciente_to_string;
        }

        $this->vdata['agendamento_paciente_to_string'] = $this->agendamento_paciente_to_string;
    }

    public function get_agendamento_paciente_to_string()
    {
        if(!empty($this->agendamento_paciente_to_string))
        {
            return $this->agendamento_paciente_to_string;
        }
    
        $values = Agendamento::where('id_procedimento', '=', $this->id)->getIndexedArray('id_paciente','{paciente->id}');
        return implode(', ', $values);
    }

    public function set_agendamento_escala_to_string($agendamento_escala_to_string)
    {
        if(is_array($agendamento_escala_to_string))
        {
            $values = Escala::where('id', 'in', $agendamento_escala_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_escala_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_escala_to_string = $agendamento_escala_to_string;
        }

        $this->vdata['agendamento_escala_to_string'] = $this->agendamento_escala_to_string;
    }

    public function get_agendamento_escala_to_string()
    {
        if(!empty($this->agendamento_escala_to_string))
        {
            return $this->agendamento_escala_to_string;
        }
    
        $values = Agendamento::where('id_procedimento', '=', $this->id)->getIndexedArray('id_escala','{escala->id}');
        return implode(', ', $values);
    }

    public function set_agendamento_unidade_saude_to_string($agendamento_unidade_saude_to_string)
    {
        if(is_array($agendamento_unidade_saude_to_string))
        {
            $values = UnidadeSaude::where('id', 'in', $agendamento_unidade_saude_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_unidade_saude_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_unidade_saude_to_string = $agendamento_unidade_saude_to_string;
        }

        $this->vdata['agendamento_unidade_saude_to_string'] = $this->agendamento_unidade_saude_to_string;
    }

    public function get_agendamento_unidade_saude_to_string()
    {
        if(!empty($this->agendamento_unidade_saude_to_string))
        {
            return $this->agendamento_unidade_saude_to_string;
        }
    
        $values = Agendamento::where('id_procedimento', '=', $this->id)->getIndexedArray('id_unidade_saude','{unidade_saude->id}');
        return implode(', ', $values);
    }

    public function set_agendamento_procedimento_to_string($agendamento_procedimento_to_string)
    {
        if(is_array($agendamento_procedimento_to_string))
        {
            $values = Procedimento::where('id', 'in', $agendamento_procedimento_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_procedimento_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_procedimento_to_string = $agendamento_procedimento_to_string;
        }

        $this->vdata['agendamento_procedimento_to_string'] = $this->agendamento_procedimento_to_string;
    }

    public function get_agendamento_procedimento_to_string()
    {
        if(!empty($this->agendamento_procedimento_to_string))
        {
            return $this->agendamento_procedimento_to_string;
        }
    
        $values = Agendamento::where('id_procedimento', '=', $this->id)->getIndexedArray('id_procedimento','{procedimento->id}');
        return implode(', ', $values);
    }

    public function set_agendamento_profissional_to_string($agendamento_profissional_to_string)
    {
        if(is_array($agendamento_profissional_to_string))
        {
            $values = Profissional::where('id', 'in', $agendamento_profissional_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_profissional_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_profissional_to_string = $agendamento_profissional_to_string;
        }

        $this->vdata['agendamento_profissional_to_string'] = $this->agendamento_profissional_to_string;
    }

    public function get_agendamento_profissional_to_string()
    {
        if(!empty($this->agendamento_profissional_to_string))
        {
            return $this->agendamento_profissional_to_string;
        }
    
        $values = Agendamento::where('id_procedimento', '=', $this->id)->getIndexedArray('id_profissional','{profissional->id}');
        return implode(', ', $values);
    }

    
}

