<?php

class Profissional extends TRecord
{
    const TABLENAME  = 'profissional';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('cpf');
        parent::addAttribute('nome_profissional');
        parent::addAttribute('cns_profissional');
        parent::addAttribute('matricula');
        parent::addAttribute('telefone');
        parent::addAttribute('flg_excluido');
            
    }

    /**
     * Method getProfissionalEquipes
     */
    public function getProfissionalEquipes()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_profissional', '=', $this->id));
        return ProfissionalEquipe::getObjects( $criteria );
    }
    /**
     * Method getEscalas
     */
    public function getEscalas()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_profissional', '=', $this->id));
        return Escala::getObjects( $criteria );
    }
    /**
     * Method getProfissionalUnidades
     */
    public function getProfissionalUnidades()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_profissional', '=', $this->id));
        return ProfissionalUnidade::getObjects( $criteria );
    }
    /**
     * Method getEnderecoProfissionals
     */
    public function getEnderecoProfissionals()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_profissional', '=', $this->id));
        return EnderecoProfissional::getObjects( $criteria );
    }
    /**
     * Method getProfissionalOcupacaos
     */
    public function getProfissionalOcupacaos()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_profissional', '=', $this->id));
        return ProfissionalOcupacao::getObjects( $criteria );
    }
    /**
     * Method getAfastamentoProfissionals
     */
    public function getAfastamentoProfissionals()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_profissional', '=', $this->id));
        return AfastamentoProfissional::getObjects( $criteria );
    }
    /**
     * Method getAgendamentos
     */
    public function getAgendamentos()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_profissional', '=', $this->id));
        return Agendamento::getObjects( $criteria );
    }

    public function set_profissional_equipe_profissional_to_string($profissional_equipe_profissional_to_string)
    {
        if(is_array($profissional_equipe_profissional_to_string))
        {
            $values = Profissional::where('id', 'in', $profissional_equipe_profissional_to_string)->getIndexedArray('id', 'id');
            $this->profissional_equipe_profissional_to_string = implode(', ', $values);
        }
        else
        {
            $this->profissional_equipe_profissional_to_string = $profissional_equipe_profissional_to_string;
        }

        $this->vdata['profissional_equipe_profissional_to_string'] = $this->profissional_equipe_profissional_to_string;
    }

    public function get_profissional_equipe_profissional_to_string()
    {
        if(!empty($this->profissional_equipe_profissional_to_string))
        {
            return $this->profissional_equipe_profissional_to_string;
        }
    
        $values = ProfissionalEquipe::where('id_profissional', '=', $this->id)->getIndexedArray('id_profissional','{profissional->id}');
        return implode(', ', $values);
    }

    public function set_profissional_equipe_equipe_to_string($profissional_equipe_equipe_to_string)
    {
        if(is_array($profissional_equipe_equipe_to_string))
        {
            $values = Equipe::where('id', 'in', $profissional_equipe_equipe_to_string)->getIndexedArray('id', 'id');
            $this->profissional_equipe_equipe_to_string = implode(', ', $values);
        }
        else
        {
            $this->profissional_equipe_equipe_to_string = $profissional_equipe_equipe_to_string;
        }

        $this->vdata['profissional_equipe_equipe_to_string'] = $this->profissional_equipe_equipe_to_string;
    }

    public function get_profissional_equipe_equipe_to_string()
    {
        if(!empty($this->profissional_equipe_equipe_to_string))
        {
            return $this->profissional_equipe_equipe_to_string;
        }
    
        $values = ProfissionalEquipe::where('id_profissional', '=', $this->id)->getIndexedArray('id_equipe','{equipe->id}');
        return implode(', ', $values);
    }

    public function set_escala_equipe_to_string($escala_equipe_to_string)
    {
        if(is_array($escala_equipe_to_string))
        {
            $values = Equipe::where('id', 'in', $escala_equipe_to_string)->getIndexedArray('id', 'id');
            $this->escala_equipe_to_string = implode(', ', $values);
        }
        else
        {
            $this->escala_equipe_to_string = $escala_equipe_to_string;
        }

        $this->vdata['escala_equipe_to_string'] = $this->escala_equipe_to_string;
    }

    public function get_escala_equipe_to_string()
    {
        if(!empty($this->escala_equipe_to_string))
        {
            return $this->escala_equipe_to_string;
        }
    
        $values = Escala::where('id_profissional', '=', $this->id)->getIndexedArray('id_equipe','{equipe->id}');
        return implode(', ', $values);
    }

    public function set_escala_profissional_to_string($escala_profissional_to_string)
    {
        if(is_array($escala_profissional_to_string))
        {
            $values = Profissional::where('id', 'in', $escala_profissional_to_string)->getIndexedArray('id', 'id');
            $this->escala_profissional_to_string = implode(', ', $values);
        }
        else
        {
            $this->escala_profissional_to_string = $escala_profissional_to_string;
        }

        $this->vdata['escala_profissional_to_string'] = $this->escala_profissional_to_string;
    }

    public function get_escala_profissional_to_string()
    {
        if(!empty($this->escala_profissional_to_string))
        {
            return $this->escala_profissional_to_string;
        }
    
        $values = Escala::where('id_profissional', '=', $this->id)->getIndexedArray('id_profissional','{profissional->id}');
        return implode(', ', $values);
    }

    public function set_escala_turno_to_string($escala_turno_to_string)
    {
        if(is_array($escala_turno_to_string))
        {
            $values = Turno::where('id', 'in', $escala_turno_to_string)->getIndexedArray('id', 'id');
            $this->escala_turno_to_string = implode(', ', $values);
        }
        else
        {
            $this->escala_turno_to_string = $escala_turno_to_string;
        }

        $this->vdata['escala_turno_to_string'] = $this->escala_turno_to_string;
    }

    public function get_escala_turno_to_string()
    {
        if(!empty($this->escala_turno_to_string))
        {
            return $this->escala_turno_to_string;
        }
    
        $values = Escala::where('id_profissional', '=', $this->id)->getIndexedArray('id_turno','{turno->id}');
        return implode(', ', $values);
    }

    public function set_escala_unidade_saude_to_string($escala_unidade_saude_to_string)
    {
        if(is_array($escala_unidade_saude_to_string))
        {
            $values = UnidadeSaude::where('id', 'in', $escala_unidade_saude_to_string)->getIndexedArray('id', 'id');
            $this->escala_unidade_saude_to_string = implode(', ', $values);
        }
        else
        {
            $this->escala_unidade_saude_to_string = $escala_unidade_saude_to_string;
        }

        $this->vdata['escala_unidade_saude_to_string'] = $this->escala_unidade_saude_to_string;
    }

    public function get_escala_unidade_saude_to_string()
    {
        if(!empty($this->escala_unidade_saude_to_string))
        {
            return $this->escala_unidade_saude_to_string;
        }
    
        $values = Escala::where('id_profissional', '=', $this->id)->getIndexedArray('id_unidade_saude','{unidade_saude->id}');
        return implode(', ', $values);
    }

    public function set_escala_procedimento_to_string($escala_procedimento_to_string)
    {
        if(is_array($escala_procedimento_to_string))
        {
            $values = Procedimento::where('id', 'in', $escala_procedimento_to_string)->getIndexedArray('id', 'id');
            $this->escala_procedimento_to_string = implode(', ', $values);
        }
        else
        {
            $this->escala_procedimento_to_string = $escala_procedimento_to_string;
        }

        $this->vdata['escala_procedimento_to_string'] = $this->escala_procedimento_to_string;
    }

    public function get_escala_procedimento_to_string()
    {
        if(!empty($this->escala_procedimento_to_string))
        {
            return $this->escala_procedimento_to_string;
        }
    
        $values = Escala::where('id_profissional', '=', $this->id)->getIndexedArray('id_procedimento','{procedimento->id}');
        return implode(', ', $values);
    }

    public function set_escala_ocupacao_to_string($escala_ocupacao_to_string)
    {
        if(is_array($escala_ocupacao_to_string))
        {
            $values = Ocupacao::where('id', 'in', $escala_ocupacao_to_string)->getIndexedArray('descricao_ocupacao', 'descricao_ocupacao');
            $this->escala_ocupacao_to_string = implode(', ', $values);
        }
        else
        {
            $this->escala_ocupacao_to_string = $escala_ocupacao_to_string;
        }

        $this->vdata['escala_ocupacao_to_string'] = $this->escala_ocupacao_to_string;
    }

    public function get_escala_ocupacao_to_string()
    {
        if(!empty($this->escala_ocupacao_to_string))
        {
            return $this->escala_ocupacao_to_string;
        }
    
        $values = Escala::where('id_profissional', '=', $this->id)->getIndexedArray('id_ocupacao','{ocupacao->descricao_ocupacao}');
        return implode(', ', $values);
    }

    public function set_profissional_unidade_profissional_to_string($profissional_unidade_profissional_to_string)
    {
        if(is_array($profissional_unidade_profissional_to_string))
        {
            $values = Profissional::where('id', 'in', $profissional_unidade_profissional_to_string)->getIndexedArray('id', 'id');
            $this->profissional_unidade_profissional_to_string = implode(', ', $values);
        }
        else
        {
            $this->profissional_unidade_profissional_to_string = $profissional_unidade_profissional_to_string;
        }

        $this->vdata['profissional_unidade_profissional_to_string'] = $this->profissional_unidade_profissional_to_string;
    }

    public function get_profissional_unidade_profissional_to_string()
    {
        if(!empty($this->profissional_unidade_profissional_to_string))
        {
            return $this->profissional_unidade_profissional_to_string;
        }
    
        $values = ProfissionalUnidade::where('id_profissional', '=', $this->id)->getIndexedArray('id_profissional','{profissional->id}');
        return implode(', ', $values);
    }

    public function set_profissional_unidade_unidade_to_string($profissional_unidade_unidade_to_string)
    {
        if(is_array($profissional_unidade_unidade_to_string))
        {
            $values = UnidadeSaude::where('id', 'in', $profissional_unidade_unidade_to_string)->getIndexedArray('id', 'id');
            $this->profissional_unidade_unidade_to_string = implode(', ', $values);
        }
        else
        {
            $this->profissional_unidade_unidade_to_string = $profissional_unidade_unidade_to_string;
        }

        $this->vdata['profissional_unidade_unidade_to_string'] = $this->profissional_unidade_unidade_to_string;
    }

    public function get_profissional_unidade_unidade_to_string()
    {
        if(!empty($this->profissional_unidade_unidade_to_string))
        {
            return $this->profissional_unidade_unidade_to_string;
        }
    
        $values = ProfissionalUnidade::where('id_profissional', '=', $this->id)->getIndexedArray('id_unidade','{unidade->id}');
        return implode(', ', $values);
    }

    public function set_profissional_unidade_setor_to_string($profissional_unidade_setor_to_string)
    {
        if(is_array($profissional_unidade_setor_to_string))
        {
            $values = Setor::where('id', 'in', $profissional_unidade_setor_to_string)->getIndexedArray('id', 'id');
            $this->profissional_unidade_setor_to_string = implode(', ', $values);
        }
        else
        {
            $this->profissional_unidade_setor_to_string = $profissional_unidade_setor_to_string;
        }

        $this->vdata['profissional_unidade_setor_to_string'] = $this->profissional_unidade_setor_to_string;
    }

    public function get_profissional_unidade_setor_to_string()
    {
        if(!empty($this->profissional_unidade_setor_to_string))
        {
            return $this->profissional_unidade_setor_to_string;
        }
    
        $values = ProfissionalUnidade::where('id_profissional', '=', $this->id)->getIndexedArray('id_setor','{setor->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_profissional_to_string($endereco_profissional_profissional_to_string)
    {
        if(is_array($endereco_profissional_profissional_to_string))
        {
            $values = Profissional::where('id', 'in', $endereco_profissional_profissional_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_profissional_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_profissional_to_string = $endereco_profissional_profissional_to_string;
        }

        $this->vdata['endereco_profissional_profissional_to_string'] = $this->endereco_profissional_profissional_to_string;
    }

    public function get_endereco_profissional_profissional_to_string()
    {
        if(!empty($this->endereco_profissional_profissional_to_string))
        {
            return $this->endereco_profissional_profissional_to_string;
        }
    
        $values = EnderecoProfissional::where('id_profissional', '=', $this->id)->getIndexedArray('id_profissional','{profissional->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_estado_to_string($endereco_profissional_estado_to_string)
    {
        if(is_array($endereco_profissional_estado_to_string))
        {
            $values = Estado::where('id', 'in', $endereco_profissional_estado_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_estado_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_estado_to_string = $endereco_profissional_estado_to_string;
        }

        $this->vdata['endereco_profissional_estado_to_string'] = $this->endereco_profissional_estado_to_string;
    }

    public function get_endereco_profissional_estado_to_string()
    {
        if(!empty($this->endereco_profissional_estado_to_string))
        {
            return $this->endereco_profissional_estado_to_string;
        }
    
        $values = EnderecoProfissional::where('id_profissional', '=', $this->id)->getIndexedArray('id_estado','{estado->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_cidade_to_string($endereco_profissional_cidade_to_string)
    {
        if(is_array($endereco_profissional_cidade_to_string))
        {
            $values = Cidade::where('id', 'in', $endereco_profissional_cidade_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_cidade_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_cidade_to_string = $endereco_profissional_cidade_to_string;
        }

        $this->vdata['endereco_profissional_cidade_to_string'] = $this->endereco_profissional_cidade_to_string;
    }

    public function get_endereco_profissional_cidade_to_string()
    {
        if(!empty($this->endereco_profissional_cidade_to_string))
        {
            return $this->endereco_profissional_cidade_to_string;
        }
    
        $values = EnderecoProfissional::where('id_profissional', '=', $this->id)->getIndexedArray('id_cidade','{cidade->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_bairro_to_string($endereco_profissional_bairro_to_string)
    {
        if(is_array($endereco_profissional_bairro_to_string))
        {
            $values = Bairro::where('id', 'in', $endereco_profissional_bairro_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_bairro_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_bairro_to_string = $endereco_profissional_bairro_to_string;
        }

        $this->vdata['endereco_profissional_bairro_to_string'] = $this->endereco_profissional_bairro_to_string;
    }

    public function get_endereco_profissional_bairro_to_string()
    {
        if(!empty($this->endereco_profissional_bairro_to_string))
        {
            return $this->endereco_profissional_bairro_to_string;
        }
    
        $values = EnderecoProfissional::where('id_profissional', '=', $this->id)->getIndexedArray('id_bairro','{bairro->id}');
        return implode(', ', $values);
    }

    public function set_endereco_profissional_tipo_to_string($endereco_profissional_tipo_to_string)
    {
        if(is_array($endereco_profissional_tipo_to_string))
        {
            $values = TipoLogradouro::where('id', 'in', $endereco_profissional_tipo_to_string)->getIndexedArray('id', 'id');
            $this->endereco_profissional_tipo_to_string = implode(', ', $values);
        }
        else
        {
            $this->endereco_profissional_tipo_to_string = $endereco_profissional_tipo_to_string;
        }

        $this->vdata['endereco_profissional_tipo_to_string'] = $this->endereco_profissional_tipo_to_string;
    }

    public function get_endereco_profissional_tipo_to_string()
    {
        if(!empty($this->endereco_profissional_tipo_to_string))
        {
            return $this->endereco_profissional_tipo_to_string;
        }
    
        $values = EnderecoProfissional::where('id_profissional', '=', $this->id)->getIndexedArray('id_tipo','{tipo->id}');
        return implode(', ', $values);
    }

    public function set_profissional_ocupacao_profissional_to_string($profissional_ocupacao_profissional_to_string)
    {
        if(is_array($profissional_ocupacao_profissional_to_string))
        {
            $values = Profissional::where('id', 'in', $profissional_ocupacao_profissional_to_string)->getIndexedArray('id', 'id');
            $this->profissional_ocupacao_profissional_to_string = implode(', ', $values);
        }
        else
        {
            $this->profissional_ocupacao_profissional_to_string = $profissional_ocupacao_profissional_to_string;
        }

        $this->vdata['profissional_ocupacao_profissional_to_string'] = $this->profissional_ocupacao_profissional_to_string;
    }

    public function get_profissional_ocupacao_profissional_to_string()
    {
        if(!empty($this->profissional_ocupacao_profissional_to_string))
        {
            return $this->profissional_ocupacao_profissional_to_string;
        }
    
        $values = ProfissionalOcupacao::where('id_profissional', '=', $this->id)->getIndexedArray('id_profissional','{profissional->id}');
        return implode(', ', $values);
    }

    public function set_profissional_ocupacao_ocupacao_to_string($profissional_ocupacao_ocupacao_to_string)
    {
        if(is_array($profissional_ocupacao_ocupacao_to_string))
        {
            $values = Ocupacao::where('id', 'in', $profissional_ocupacao_ocupacao_to_string)->getIndexedArray('descricao_ocupacao', 'descricao_ocupacao');
            $this->profissional_ocupacao_ocupacao_to_string = implode(', ', $values);
        }
        else
        {
            $this->profissional_ocupacao_ocupacao_to_string = $profissional_ocupacao_ocupacao_to_string;
        }

        $this->vdata['profissional_ocupacao_ocupacao_to_string'] = $this->profissional_ocupacao_ocupacao_to_string;
    }

    public function get_profissional_ocupacao_ocupacao_to_string()
    {
        if(!empty($this->profissional_ocupacao_ocupacao_to_string))
        {
            return $this->profissional_ocupacao_ocupacao_to_string;
        }
    
        $values = ProfissionalOcupacao::where('id_profissional', '=', $this->id)->getIndexedArray('id_ocupacao','{ocupacao->descricao_ocupacao}');
        return implode(', ', $values);
    }

    public function set_afastamento_profissional_profissional_to_string($afastamento_profissional_profissional_to_string)
    {
        if(is_array($afastamento_profissional_profissional_to_string))
        {
            $values = Profissional::where('id', 'in', $afastamento_profissional_profissional_to_string)->getIndexedArray('id', 'id');
            $this->afastamento_profissional_profissional_to_string = implode(', ', $values);
        }
        else
        {
            $this->afastamento_profissional_profissional_to_string = $afastamento_profissional_profissional_to_string;
        }

        $this->vdata['afastamento_profissional_profissional_to_string'] = $this->afastamento_profissional_profissional_to_string;
    }

    public function get_afastamento_profissional_profissional_to_string()
    {
        if(!empty($this->afastamento_profissional_profissional_to_string))
        {
            return $this->afastamento_profissional_profissional_to_string;
        }
    
        $values = AfastamentoProfissional::where('id_profissional', '=', $this->id)->getIndexedArray('id_profissional','{profissional->id}');
        return implode(', ', $values);
    }

    public function set_agendamento_paciente_to_string($agendamento_paciente_to_string)
    {
        if(is_array($agendamento_paciente_to_string))
        {
            $values = Paciente::where('id', 'in', $agendamento_paciente_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_paciente_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_paciente_to_string = $agendamento_paciente_to_string;
        }

        $this->vdata['agendamento_paciente_to_string'] = $this->agendamento_paciente_to_string;
    }

    public function get_agendamento_paciente_to_string()
    {
        if(!empty($this->agendamento_paciente_to_string))
        {
            return $this->agendamento_paciente_to_string;
        }
    
        $values = Agendamento::where('id_profissional', '=', $this->id)->getIndexedArray('id_paciente','{paciente->id}');
        return implode(', ', $values);
    }

    public function set_agendamento_escala_to_string($agendamento_escala_to_string)
    {
        if(is_array($agendamento_escala_to_string))
        {
            $values = Escala::where('id', 'in', $agendamento_escala_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_escala_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_escala_to_string = $agendamento_escala_to_string;
        }

        $this->vdata['agendamento_escala_to_string'] = $this->agendamento_escala_to_string;
    }

    public function get_agendamento_escala_to_string()
    {
        if(!empty($this->agendamento_escala_to_string))
        {
            return $this->agendamento_escala_to_string;
        }
    
        $values = Agendamento::where('id_profissional', '=', $this->id)->getIndexedArray('id_escala','{escala->id}');
        return implode(', ', $values);
    }

    public function set_agendamento_unidade_saude_to_string($agendamento_unidade_saude_to_string)
    {
        if(is_array($agendamento_unidade_saude_to_string))
        {
            $values = UnidadeSaude::where('id', 'in', $agendamento_unidade_saude_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_unidade_saude_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_unidade_saude_to_string = $agendamento_unidade_saude_to_string;
        }

        $this->vdata['agendamento_unidade_saude_to_string'] = $this->agendamento_unidade_saude_to_string;
    }

    public function get_agendamento_unidade_saude_to_string()
    {
        if(!empty($this->agendamento_unidade_saude_to_string))
        {
            return $this->agendamento_unidade_saude_to_string;
        }
    
        $values = Agendamento::where('id_profissional', '=', $this->id)->getIndexedArray('id_unidade_saude','{unidade_saude->id}');
        return implode(', ', $values);
    }

    public function set_agendamento_procedimento_to_string($agendamento_procedimento_to_string)
    {
        if(is_array($agendamento_procedimento_to_string))
        {
            $values = Procedimento::where('id', 'in', $agendamento_procedimento_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_procedimento_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_procedimento_to_string = $agendamento_procedimento_to_string;
        }

        $this->vdata['agendamento_procedimento_to_string'] = $this->agendamento_procedimento_to_string;
    }

    public function get_agendamento_procedimento_to_string()
    {
        if(!empty($this->agendamento_procedimento_to_string))
        {
            return $this->agendamento_procedimento_to_string;
        }
    
        $values = Agendamento::where('id_profissional', '=', $this->id)->getIndexedArray('id_procedimento','{procedimento->id}');
        return implode(', ', $values);
    }

    public function set_agendamento_profissional_to_string($agendamento_profissional_to_string)
    {
        if(is_array($agendamento_profissional_to_string))
        {
            $values = Profissional::where('id', 'in', $agendamento_profissional_to_string)->getIndexedArray('id', 'id');
            $this->agendamento_profissional_to_string = implode(', ', $values);
        }
        else
        {
            $this->agendamento_profissional_to_string = $agendamento_profissional_to_string;
        }

        $this->vdata['agendamento_profissional_to_string'] = $this->agendamento_profissional_to_string;
    }

    public function get_agendamento_profissional_to_string()
    {
        if(!empty($this->agendamento_profissional_to_string))
        {
            return $this->agendamento_profissional_to_string;
        }
    
        $values = Agendamento::where('id_profissional', '=', $this->id)->getIndexedArray('id_profissional','{profissional->id}');
        return implode(', ', $values);
    }

    
}

