<?php

class ProfissionalEquipe extends TRecord
{
    const TABLENAME  = 'profissional_equipe';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $profissional;
    private $equipe;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('id_profissional');
        parent::addAttribute('id_equipe');
            
    }

    /**
     * Method set_profissional
     * Sample of usage: $var->profissional = $object;
     * @param $object Instance of Profissional
     */
    public function set_profissional(Profissional $object)
    {
        $this->profissional = $object;
        $this->id_profissional = $object->id;
    }

    /**
     * Method get_profissional
     * Sample of usage: $var->profissional->attribute;
     * @returns Profissional instance
     */
    public function get_profissional()
    {
    
        // loads the associated object
        if (empty($this->profissional))
            $this->profissional = new Profissional($this->id_profissional);
    
        // returns the associated object
        return $this->profissional;
    }
    /**
     * Method set_equipe
     * Sample of usage: $var->equipe = $object;
     * @param $object Instance of Equipe
     */
    public function set_equipe(Equipe $object)
    {
        $this->equipe = $object;
        $this->id_equipe = $object->id;
    }

    /**
     * Method get_equipe
     * Sample of usage: $var->equipe->attribute;
     * @returns Equipe instance
     */
    public function get_equipe()
    {
    
        // loads the associated object
        if (empty($this->equipe))
            $this->equipe = new Equipe($this->id_equipe);
    
        // returns the associated object
        return $this->equipe;
    }

    
}

