<?php

class ProfissionalOcupacao extends TRecord
{
    const TABLENAME  = 'profissional_ocupacao';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $profissional;
    private $ocupacao;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('id_profissional');
        parent::addAttribute('id_ocupacao');
            
    }

    /**
     * Method set_profissional
     * Sample of usage: $var->profissional = $object;
     * @param $object Instance of Profissional
     */
    public function set_profissional(Profissional $object)
    {
        $this->profissional = $object;
        $this->id_profissional = $object->id;
    }

    /**
     * Method get_profissional
     * Sample of usage: $var->profissional->attribute;
     * @returns Profissional instance
     */
    public function get_profissional()
    {
    
        // loads the associated object
        if (empty($this->profissional))
            $this->profissional = new Profissional($this->id_profissional);
    
        // returns the associated object
        return $this->profissional;
    }
    /**
     * Method set_ocupacao
     * Sample of usage: $var->ocupacao = $object;
     * @param $object Instance of Ocupacao
     */
    public function set_ocupacao(Ocupacao $object)
    {
        $this->ocupacao = $object;
        $this->id_ocupacao = $object->id;
    }

    /**
     * Method get_ocupacao
     * Sample of usage: $var->ocupacao->attribute;
     * @returns Ocupacao instance
     */
    public function get_ocupacao()
    {
    
        // loads the associated object
        if (empty($this->ocupacao))
            $this->ocupacao = new Ocupacao($this->id_ocupacao);
    
        // returns the associated object
        return $this->ocupacao;
    }

    
}

