<?php

class ProfissionalUnidade extends TRecord
{
    const TABLENAME  = 'profissional_unidade';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $profissional;
    private $unidade;
    private $setor;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('id_profissional');
        parent::addAttribute('id_unidade');
        parent::addAttribute('id_setor');
            
    }

    /**
     * Method set_profissional
     * Sample of usage: $var->profissional = $object;
     * @param $object Instance of Profissional
     */
    public function set_profissional(Profissional $object)
    {
        $this->profissional = $object;
        $this->id_profissional = $object->id;
    }

    /**
     * Method get_profissional
     * Sample of usage: $var->profissional->attribute;
     * @returns Profissional instance
     */
    public function get_profissional()
    {
    
        // loads the associated object
        if (empty($this->profissional))
            $this->profissional = new Profissional($this->id_profissional);
    
        // returns the associated object
        return $this->profissional;
    }
    /**
     * Method set_unidade_saude
     * Sample of usage: $var->unidade_saude = $object;
     * @param $object Instance of UnidadeSaude
     */
    public function set_unidade(UnidadeSaude $object)
    {
        $this->unidade = $object;
        $this->id_unidade = $object->id;
    }

    /**
     * Method get_unidade
     * Sample of usage: $var->unidade->attribute;
     * @returns UnidadeSaude instance
     */
    public function get_unidade()
    {
    
        // loads the associated object
        if (empty($this->unidade))
            $this->unidade = new UnidadeSaude($this->id_unidade);
    
        // returns the associated object
        return $this->unidade;
    }
    /**
     * Method set_setor
     * Sample of usage: $var->setor = $object;
     * @param $object Instance of Setor
     */
    public function set_setor(Setor $object)
    {
        $this->setor = $object;
        $this->id_setor = $object->id;
    }

    /**
     * Method get_setor
     * Sample of usage: $var->setor->attribute;
     * @returns Setor instance
     */
    public function get_setor()
    {
    
        // loads the associated object
        if (empty($this->setor))
            $this->setor = new Setor($this->id_setor);
    
        // returns the associated object
        return $this->setor;
    }

    
}

