<?php

class Regiao extends TRecord
{
    const TABLENAME  = 'regiao';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $estado;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('nome_regiao');
        parent::addAttribute('id_estado');
            
    }

    /**
     * Method set_estado
     * Sample of usage: $var->estado = $object;
     * @param $object Instance of Estado
     */
    public function set_estado(Estado $object)
    {
        $this->estado = $object;
        $this->id_estado = $object->id;
    }

    /**
     * Method get_estado
     * Sample of usage: $var->estado->attribute;
     * @returns Estado instance
     */
    public function get_estado()
    {
    
        // loads the associated object
        if (empty($this->estado))
            $this->estado = new Estado($this->id_estado);
    
        // returns the associated object
        return $this->estado;
    }

    /**
     * Method getCidades
     */
    public function getCidades()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_regiao', '=', $this->id));
        return Cidade::getObjects( $criteria );
    }

    public function set_cidade_estado_to_string($cidade_estado_to_string)
    {
        if(is_array($cidade_estado_to_string))
        {
            $values = Estado::where('id', 'in', $cidade_estado_to_string)->getIndexedArray('id', 'id');
            $this->cidade_estado_to_string = implode(', ', $values);
        }
        else
        {
            $this->cidade_estado_to_string = $cidade_estado_to_string;
        }

        $this->vdata['cidade_estado_to_string'] = $this->cidade_estado_to_string;
    }

    public function get_cidade_estado_to_string()
    {
        if(!empty($this->cidade_estado_to_string))
        {
            return $this->cidade_estado_to_string;
        }
    
        $values = Cidade::where('id_regiao', '=', $this->id)->getIndexedArray('id_estado','{estado->id}');
        return implode(', ', $values);
    }

    public function set_cidade_regiao_to_string($cidade_regiao_to_string)
    {
        if(is_array($cidade_regiao_to_string))
        {
            $values = Regiao::where('id', 'in', $cidade_regiao_to_string)->getIndexedArray('id', 'id');
            $this->cidade_regiao_to_string = implode(', ', $values);
        }
        else
        {
            $this->cidade_regiao_to_string = $cidade_regiao_to_string;
        }

        $this->vdata['cidade_regiao_to_string'] = $this->cidade_regiao_to_string;
    }

    public function get_cidade_regiao_to_string()
    {
        if(!empty($this->cidade_regiao_to_string))
        {
            return $this->cidade_regiao_to_string;
        }
    
        $values = Cidade::where('id_regiao', '=', $this->id)->getIndexedArray('id_regiao','{regiao->id}');
        return implode(', ', $values);
    }

    
}

