<?php

class Setor extends TRecord
{
    const TABLENAME  = 'setor';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    private $unidade;

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('id_unidade');
        parent::addAttribute('descricao_setor');
            
    }

    /**
     * Method set_unidade_saude
     * Sample of usage: $var->unidade_saude = $object;
     * @param $object Instance of UnidadeSaude
     */
    public function set_unidade(UnidadeSaude $object)
    {
        $this->unidade = $object;
        $this->id_unidade = $object->id;
    }

    /**
     * Method get_unidade
     * Sample of usage: $var->unidade->attribute;
     * @returns UnidadeSaude instance
     */
    public function get_unidade()
    {
    
        // loads the associated object
        if (empty($this->unidade))
            $this->unidade = new UnidadeSaude($this->id_unidade);
    
        // returns the associated object
        return $this->unidade;
    }

    /**
     * Method getProfissionalUnidades
     */
    public function getProfissionalUnidades()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_setor', '=', $this->id));
        return ProfissionalUnidade::getObjects( $criteria );
    }

    public function set_profissional_unidade_profissional_to_string($profissional_unidade_profissional_to_string)
    {
        if(is_array($profissional_unidade_profissional_to_string))
        {
            $values = Profissional::where('id', 'in', $profissional_unidade_profissional_to_string)->getIndexedArray('id', 'id');
            $this->profissional_unidade_profissional_to_string = implode(', ', $values);
        }
        else
        {
            $this->profissional_unidade_profissional_to_string = $profissional_unidade_profissional_to_string;
        }

        $this->vdata['profissional_unidade_profissional_to_string'] = $this->profissional_unidade_profissional_to_string;
    }

    public function get_profissional_unidade_profissional_to_string()
    {
        if(!empty($this->profissional_unidade_profissional_to_string))
        {
            return $this->profissional_unidade_profissional_to_string;
        }
    
        $values = ProfissionalUnidade::where('id_setor', '=', $this->id)->getIndexedArray('id_profissional','{profissional->id}');
        return implode(', ', $values);
    }

    public function set_profissional_unidade_unidade_to_string($profissional_unidade_unidade_to_string)
    {
        if(is_array($profissional_unidade_unidade_to_string))
        {
            $values = UnidadeSaude::where('id', 'in', $profissional_unidade_unidade_to_string)->getIndexedArray('id', 'id');
            $this->profissional_unidade_unidade_to_string = implode(', ', $values);
        }
        else
        {
            $this->profissional_unidade_unidade_to_string = $profissional_unidade_unidade_to_string;
        }

        $this->vdata['profissional_unidade_unidade_to_string'] = $this->profissional_unidade_unidade_to_string;
    }

    public function get_profissional_unidade_unidade_to_string()
    {
        if(!empty($this->profissional_unidade_unidade_to_string))
        {
            return $this->profissional_unidade_unidade_to_string;
        }
    
        $values = ProfissionalUnidade::where('id_setor', '=', $this->id)->getIndexedArray('id_unidade','{unidade->id}');
        return implode(', ', $values);
    }

    public function set_profissional_unidade_setor_to_string($profissional_unidade_setor_to_string)
    {
        if(is_array($profissional_unidade_setor_to_string))
        {
            $values = Setor::where('id', 'in', $profissional_unidade_setor_to_string)->getIndexedArray('id', 'id');
            $this->profissional_unidade_setor_to_string = implode(', ', $values);
        }
        else
        {
            $this->profissional_unidade_setor_to_string = $profissional_unidade_setor_to_string;
        }

        $this->vdata['profissional_unidade_setor_to_string'] = $this->profissional_unidade_setor_to_string;
    }

    public function get_profissional_unidade_setor_to_string()
    {
        if(!empty($this->profissional_unidade_setor_to_string))
        {
            return $this->profissional_unidade_setor_to_string;
        }
    
        $values = ProfissionalUnidade::where('id_setor', '=', $this->id)->getIndexedArray('id_setor','{setor->id}');
        return implode(', ', $values);
    }

    
}

