<?php

class TipoAlergia extends TRecord
{
    const TABLENAME  = 'tipo_alergia';
    const PRIMARYKEY = 'id';
    const IDPOLICY   =  'serial'; // {max, serial}

    

    /**
     * Constructor method
     */
    public function __construct($id = NULL, $callObjectLoad = TRUE)
    {
        parent::__construct($id, $callObjectLoad);
        parent::addAttribute('descricao');
            
    }

    /**
     * Method getAlergiaAvaliacaos
     */
    public function getAlergiaAvaliacaos()
    {
        $criteria = new TCriteria;
        $criteria->add(new TFilter('id_tipo_alergia', '=', $this->id));
        return AlergiaAvaliacao::getObjects( $criteria );
    }

    public function set_alergia_avaliacao_tipo_alergia_to_string($alergia_avaliacao_tipo_alergia_to_string)
    {
        if(is_array($alergia_avaliacao_tipo_alergia_to_string))
        {
            $values = TipoAlergia::where('id', 'in', $alergia_avaliacao_tipo_alergia_to_string)->getIndexedArray('id', 'id');
            $this->alergia_avaliacao_tipo_alergia_to_string = implode(', ', $values);
        }
        else
        {
            $this->alergia_avaliacao_tipo_alergia_to_string = $alergia_avaliacao_tipo_alergia_to_string;
        }

        $this->vdata['alergia_avaliacao_tipo_alergia_to_string'] = $this->alergia_avaliacao_tipo_alergia_to_string;
    }

    public function get_alergia_avaliacao_tipo_alergia_to_string()
    {
        if(!empty($this->alergia_avaliacao_tipo_alergia_to_string))
        {
            return $this->alergia_avaliacao_tipo_alergia_to_string;
        }
    
        $values = AlergiaAvaliacao::where('id_tipo_alergia', '=', $this->id)->getIndexedArray('id_tipo_alergia','{tipo_alergia->id}');
        return implode(', ', $values);
    }

    public function set_alergia_avaliacao_avaliacao_medica_to_string($alergia_avaliacao_avaliacao_medica_to_string)
    {
        if(is_array($alergia_avaliacao_avaliacao_medica_to_string))
        {
            $values = AvaliacaoMedica::where('id', 'in', $alergia_avaliacao_avaliacao_medica_to_string)->getIndexedArray('id', 'id');
            $this->alergia_avaliacao_avaliacao_medica_to_string = implode(', ', $values);
        }
        else
        {
            $this->alergia_avaliacao_avaliacao_medica_to_string = $alergia_avaliacao_avaliacao_medica_to_string;
        }

        $this->vdata['alergia_avaliacao_avaliacao_medica_to_string'] = $this->alergia_avaliacao_avaliacao_medica_to_string;
    }

    public function get_alergia_avaliacao_avaliacao_medica_to_string()
    {
        if(!empty($this->alergia_avaliacao_avaliacao_medica_to_string))
        {
            return $this->alergia_avaliacao_avaliacao_medica_to_string;
        }
    
        $values = AlergiaAvaliacao::where('id_tipo_alergia', '=', $this->id)->getIndexedArray('id_avaliacao_medica','{avaliacao_medica->id}');
        return implode(', ', $values);
    }

    
}

